//
//  BIPDFDocumentGenerator.h
//  BIReports
//
//  Created by Alykhan Jetha on 10-05-13.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportWrapper;
@class MCReportLayout;
@class MCReportGenerator;
@class MCPDatabaseObjectContext;
@class BIClient;
@class BIURLReference;

@interface BIPDFDocumentGenerator : NSObject 
{

	MCReportWrapper *reportWrapper;
	MCReportLayout *reportLayout;
	NSDictionary *customizationProperties;
	NSDictionary *requestRepresentation;
	
	MCPDatabaseObjectContext *objectContext;
	
	MCReportGenerator *documentGenerator;
	
	BIClient *client;
	id documentObject;
	
	BOOL isPreview;
	BOOL wantsPDFasFilePath;
	BOOL wantsEmbededStorage;

}

@property (assign) BOOL isPreview;
@property (assign) BOOL wantsPDFasFilePath;
@property (assign) BOOL wantsEmbededStorage;
@property (retain) MCReportWrapper *reportWrapper;
@property (retain) MCPDatabaseObjectContext *objectContext;
@property (retain) NSDictionary *customizationProperties;
@property (retain) NSDictionary *requestRepresentation;
@property (retain) MCReportGenerator *documentGenerator;
@property (retain) BIClient *client;
@property (retain) id documentObject;


- (id)initWithRepresentation:(NSDictionary *)invRep objectContext:(MCPDatabaseObjectContext *)oc;


- (MCReportLayout *)documentLayout;
 

- (NSString *)newTemporaryFilePath;

- (MCReportGenerator *)prepareGenerator;

/*!
 Gives subclassers a chance to customize the template as needed. Default does nothing.
 */
- (void)prepareCustomizationsForLayout:(MCReportLayout *)layout;
- (void)prepareFormattersForGenerator:(MCReportGenerator *)gen;
- (void)prepareArguments:(NSMutableDictionary *)args;
- (void)prepareDocumentObject:(id)docObj;
/*!
 Subclasses can do what they need to do to finalize. Return a bunch of keys that will get added to the dictionary returned by -generate;
 */
- (NSDictionary *)postProcessDocumentObject:(id)docObj generatedDocumentAtPath:(NSString *)aPath;


/*!
 Generates the results and puts it in a dictionary. The dictionary will contain storage details.
 
 pdfPath
 pdfData
 entity = Invoice; ProFormaInvoice; Statement; Estimate
 entityID = 1212
 urlReferenceID = 2321312
 filename = Invoice_342_23432_34.pdf
 
 */
- (NSDictionary *)generate;


- (NSInteger)urlReferenceKind;

- (NSInteger)incrementObjectNumber;
- (NSString *)generateObjectNumber;

- (NSString *)nextObjectNumberKey;
- (NSString *)numPaddingLengthKey;
- (NSString *)objPrefixKey;
- (NSString *)expandDynamicText:(NSString*)theText;

- (NSString *)documentLabelForFilename;
- (NSString *)clientSideFolderForDocumentObject:(id)docObj;
- (NSString *)generateClientSideFilenameForDocumentObject:(id)docObj;


- (BIURLReference *)createURLReferenceForDocumentObject:(id)docObj forContentsAtPath:(NSString *)aPath;

@end
